package com.agilex.healthcare.veteranappointment.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@JsonAutoDetect
public class VARAppointmentRequestMessages extends VARPatientDataCollection<VARAppointmentRequestMessage> {
    private static final long serialVersionUID = -1232048559610824266L;

	@JsonCreator
	public VARAppointmentRequestMessages(){
		super();
	}

	@JsonProperty("appointmentRequestMessage")
	public Collection<VARAppointmentRequestMessage> getAppointmentRequestMessage() {
		List<VARAppointmentRequestMessage> list = new ArrayList<VARAppointmentRequestMessage>();
		for (VARAppointmentRequestMessage varAppointmentRequestMessage : this) {
			list.add(varAppointmentRequestMessage);
		}
		return list;
	}

	public void setAppointmentRequestMessage(Collection<VARAppointmentRequestMessage> items){
		this.addAll(items);
	}

}
